﻿using System;
using System.Collections.Generic;
using System.Windows.Media;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Ink;
using System.Windows.Controls;
using System.Windows;
using System.Windows.Controls.Primitives;

namespace WpfApp1.Structure
{
    public class Symbol
    {
        public int id;
        public string text { get; set; }
        public string category;
        public string color { get; set; }
        public double[] center;
        public TextBox text_box;
        public Thumb text_thumb;
        public StrokeCollection strokes;
        public List<Symbol> inclusions;  //未更新

        public Symbol(int id, string text, string category, string color, double[] center, StrokeCollection strokes, List<Symbol> inclusions, Canvas video_text)
        {
            this.id = id;
            this.text = text;
            this.category = category;
            this.color = color;
            this.center = center.ToArray();
            //this.text_box = new TextBox();
            //this.text_box.TextChanged += text_box_TextChanged;
            //this.text_box.SizeChanged += text_box_SizeChanged;
            //this.text_box.FontSize = 16;
            ////this.text_box.FontWeight = FontWeights.Bold;
            //this.text_box.MinWidth = 10;
            //this.text_box.BorderThickness = new Thickness(0);
            //this.text_box.Background = new SolidColorBrush(Colors.Transparent);
            //this.text_box.Foreground = new SolidColorBrush(Colors.Black);
            //this.text_box.TextAlignment = TextAlignment.Center;
            //this.text_box.TextWrapping = TextWrapping.Wrap;
            ////this.text_box.IsHitTestVisible = false;
            //this.text_box.Style = (Style)Application.Current.Resources["TextBox"];
            //this.text_box.Text = text;
            //video_text.Children.Add(this.text_box);

            //this.text_thumb = new Thumb
            //{
            //    HorizontalAlignment = HorizontalAlignment.Center,
            //    VerticalAlignment = VerticalAlignment.Center,
            //    Background = new SolidColorBrush(Colors.Black),
            //    Padding = new Thickness(5),
            //    BorderThickness = new Thickness(5),
            //    BorderBrush = new SolidColorBrush(Colors.Black),
            //};
            //FrameworkElementFactory textBoxFactory = new FrameworkElementFactory
            //{
            //    Type = typeof(TextBox),
            //    Name = "text_box"
            //};
            //textBoxFactory.SetValue(TextBox.StyleProperty, null);
            //textBoxFactory.SetValue(TextBox.TextProperty, text);
            //textBoxFactory.SetValue(TextBox.MarginProperty, new Thickness(5));

            this.text_thumb = new Thumb();
            FrameworkElementFactory borderFactory = new FrameworkElementFactory
            {
                Type = typeof(Border),
                Name = "text_border"
            };
            borderFactory.SetValue(Border.BackgroundProperty, new SolidColorBrush(Colors.Transparent));
            FrameworkElementFactory textBoxFactory = new FrameworkElementFactory
            {
                Type = typeof(TextBox),
                Name = "text_box"
            };
            textBoxFactory.SetValue(TextBox.StyleProperty, null);
            textBoxFactory.SetValue(TextBox.FontSizeProperty, 16.0);
            textBoxFactory.SetValue(TextBox.TextAlignmentProperty, TextAlignment.Center);
            textBoxFactory.SetValue(TextBox.TextWrappingProperty, TextWrapping.Wrap);
            textBoxFactory.SetValue(TextBox.BackgroundProperty, new SolidColorBrush(Colors.Transparent));
            textBoxFactory.SetValue(TextBox.BorderThicknessProperty, new Thickness(0));
            textBoxFactory.SetValue(TextBox.MarginProperty, new Thickness(5));
            textBoxFactory.SetValue(TextBox.TextProperty, text);
            borderFactory.AppendChild(textBoxFactory);
            this.text_thumb.Template = new ControlTemplate { VisualTree = borderFactory };
            this.text_thumb.Loaded += text_thumb_Loaded;
            this.text_thumb.DragDelta += text_thumb_DragDelta;
            video_text.Children.Add(this.text_thumb);
            this.text_thumb.ApplyTemplate();
            this.strokes = strokes.Clone();
            this.inclusions = inclusions.ToList();
            //RefreshTextBox();
        }

        public Symbol(int id, Canvas video_text)
        {
            this.id = id;
            this.text = "";
            this.category = "";
            this.color = "";
            this.center = new double[2];
            //this.text_box = new TextBox();
            //this.text_box.TextChanged += text_box_TextChanged;
            //this.text_box.SizeChanged += text_box_SizeChanged;
            //this.text_box.FontSize = 16;
            ////this.text_box.FontWeight = FontWeights.Bold;
            //this.text_box.MinWidth = 10;
            //this.text_box.BorderThickness = new Thickness(0);
            //this.text_box.Background = new SolidColorBrush(Colors.Transparent);
            //this.text_box.Foreground = new SolidColorBrush(Colors.Black);
            //this.text_box.TextAlignment = TextAlignment.Center;
            //this.text_box.TextWrapping = TextWrapping.Wrap;
            ////this.text_box.IsHitTestVisible = false;
            //this.text_box.Style = (Style)Application.Current.Resources["TextBox"];
            //video_text.Children.Add(this.text_box);
            this.text_thumb = new Thumb();
            FrameworkElementFactory borderFactory = new FrameworkElementFactory
            {
                Type = typeof(Border),
                Name = "text_border"
            };
            borderFactory.SetValue(Border.BackgroundProperty, new SolidColorBrush(Colors.Transparent));
            FrameworkElementFactory textBoxFactory = new FrameworkElementFactory
            {
                Type = typeof(TextBox),
                Name = "text_box"
            };
            textBoxFactory.SetValue(TextBox.StyleProperty, null);
            textBoxFactory.SetValue(TextBox.FontSizeProperty, 16.0);
            textBoxFactory.SetValue(TextBox.TextAlignmentProperty, TextAlignment.Center);
            textBoxFactory.SetValue(TextBox.TextWrappingProperty, TextWrapping.Wrap);
            textBoxFactory.SetValue(TextBox.BackgroundProperty, new SolidColorBrush(Colors.Transparent));
            textBoxFactory.SetValue(TextBox.BorderThicknessProperty, new Thickness(0));
            textBoxFactory.SetValue(TextBox.MarginProperty, new Thickness(5));
            textBoxFactory.SetValue(TextBox.TextProperty, text);
            borderFactory.AppendChild(textBoxFactory);
            this.text_thumb.Template = new ControlTemplate { VisualTree = borderFactory };
            this.text_thumb.Loaded += text_thumb_Loaded;
            this.text_thumb.DragDelta += text_thumb_DragDelta;
            video_text.Children.Add(this.text_thumb);
            this.text_thumb.ApplyTemplate();
            this.strokes = new StrokeCollection();
            this.inclusions = new List<Symbol>();
        }

        private void text_thumb_Loaded(object sender, RoutedEventArgs e)
        {
            text_box = text_thumb.Template.FindName("text_box", text_thumb) as TextBox;
            text_box.TextChanged += text_box_TextChanged;
            text_box.SizeChanged += text_box_SizeChanged;
            text_box.Text = text;
            RefreshTextBox();
        }

        private void text_thumb_DragDelta(object sender, DragDeltaEventArgs e)
        {
            Canvas.SetLeft(text_thumb, Canvas.GetLeft(text_thumb) + e.HorizontalChange);
            Canvas.SetTop(text_thumb, Canvas.GetTop(text_thumb) + e.VerticalChange);
        }

        private void text_box_TextChanged(object sender, TextChangedEventArgs e)
        {
            text = text_box.Text;
        }

        private void text_box_SizeChanged(object sender, SizeChangedEventArgs e)
        {
            RefreshTextBoxPos();
        }

        //设置所有成员（string）
        public void SetParam(string text, string category, string color)
        {
            //category -> color -> text
            SetCategory(category);
            SetColor(color);
            SetText(text);
        }

        public virtual void SetText(string text)
        {
            this.text = text;
            Rect boundingBox;
            if (strokes.Count > 0)
            {
                boundingBox = strokes.GetBounds();
            }
            else
            {
                boundingBox = new Rect(center[0] - 90, center[1] - 60, 180, 120);
            }
            text_thumb.Width = Math.Min(text_thumb.Width, boundingBox.Width * 0.8);
            //text_box.Text = text;
        }

        public virtual void SetCategory(string category)
        {
            this.category = category;
        }

        public virtual void SetColor(string color)
        {
            this.color = color;
            foreach (Stroke stroke in strokes)
            {
                stroke.DrawingAttributes.Color = SymbolColor.d_Colors[color];
            }
        }

        //public void SetCenter(double centerX, double centerY)
        //{

        //}

        //保持中心点
        public virtual void SetStrokes(StrokeCollection strokes)
        {
            Rect rect = strokes.GetBounds();
            double movedDistanceX = rect.X + rect.Width / 2 - center[0];
            double movedDistanceY = rect.Y + rect.Height / 2 - center[1];
            Matrix matrix = new Matrix();
            matrix.Translate(movedDistanceX, movedDistanceY);
            foreach (Stroke stroke in strokes)
            {
                stroke.Transform(matrix, false);
            }
            this.strokes = strokes.Clone();
            Resized();
        }

        public void RefreshCenter()
        {
            Rect boundingBox = strokes.GetBounds();
            center[0] = boundingBox.Left + boundingBox.Width / 2;
            center[1] = boundingBox.Top + boundingBox.Height / 2;
        }

        public virtual void RefreshTextBoxPos()
        {
            //double X = center[0] - text_box.ActualWidth / 2;
            //double Y = center[1] - text_box.ActualHeight / 2;
            //Canvas.SetLeft(text_box, X);
            //Canvas.SetTop(text_box, Y);
            double X = center[0] - text_thumb.ActualWidth / 2;
            double Y = center[1] - text_thumb.ActualHeight / 2;
            if (id == 198)
            {
                Y -= 5;
            }
            Canvas.SetLeft(text_thumb, X);
            Canvas.SetTop(text_thumb, Y);
        }

        public virtual void RefreshTextBox()
        {
            Rect boundingBox;
            if (strokes.Count > 0)
            {
                boundingBox = strokes.GetBounds();
            }
            else
            {
                boundingBox = new Rect(center[0] - 90, center[1] - 60, 180, 120);
            }
            text_thumb.MaxWidth = boundingBox.Width * 0.8;
            RefreshTextBoxPos();
        }

        public void Moved()
        {
            RefreshCenter();
            RefreshTextBoxPos();
        }

        public void Resized()
        {
            RefreshCenter();
            RefreshTextBox();
        }

        public void Deleted()
        {
            text_box.Visibility = Visibility.Collapsed;
        }

        public void Added()
        {
            text_box.Visibility = Visibility.Visible;
        }

        public virtual Symbol Clone()
        {
            Symbol symbol = new Symbol(id, text, category, color, center, strokes, inclusions, text_box.Parent as Canvas);
            symbol.text_box.Visibility = Visibility.Collapsed;
            return symbol;
        }

        //移出结构
        public virtual void Disconnect()
        {
            foreach (Content content in this.inclusions)
            {
                content.groups.Remove(this);
            }
        }

        //移回结构
        public virtual void Connect()
        {
            foreach (Content content in this.inclusions)
            {
                content.groups.Add(this);
            }
        }
    }
}
